up:: [[Ancient Greece MOC]]
tags:: #source/book 
dates:: 150 CE

# 150 📚 The Almagest
The Almagest is a 2nd-century Greek-language mathematical and astronomical treatise on the apparent motions of the stars and planetary paths, written by Claudius [[Ptolemy (kit)]]

### Here's me opining about this foundational text
- The Almagest shows our ability to problem solve
- The Almagest shows that: if it practically works, it's more believable
- The Almagest shows our ability to force fit incorrect solutions, and then believe those solutions
- The Almagest shows how we conflate some truth in a person, statement, or idea, with total truth 
	- But that's not the case: [[People's attributes are domain-specific]]
- Belief governs reality
- Even in the face of overwhelming evidence, Belief finds a way
- The fluid in the ear keeps our equilibrium, 
- We have an existential protection mechanism that filters out details that challenge our beliefs
- When reality disproves our beliefs, we either ignore, punch back, distract, ("whataboutism"), or tack onto the narrative
- When reality disproves our beliefs, it's easier to change the narrative protecting our beliefs, than to actually change our beliefs
- Be careful what you believe, because your beliefs exert mind control on you
- Geocentrism shows our vanity, our ego, our narcissism
- ❓ I wonder how much sooner the Chinese accepted the earth was round
- ❓ I wonder how much sooner the Chinese accepted the earth was not the center of the universe
- We just believe whatever we want to believe

---

## Cite

### 1999 📚 The Cambridge Concise History of Astronomy
- Michael Hoskin, Cambridge University Press, Mar 18, 1999 - 362 pages
- Astronomy is one of the oldest sciences, and one which has repeatedly led to fundamental changes in our view of the world. This book covers the history of our study of the cosmos from prehistory to a survey of modern astronomy and astrophysics. It does not attempt to cover everything, but deliberately concentrates on the important themes and topics, including stellar astronomy in the seventeenth and eighteenth centuries--the source of many important concepts in modern astronomy--and the Copernican revolution, which led to the challenge of ancient authorities in many areas other than astronomy. This is an essential text for students of the history of science and for students of astronomy who require a historical background to their studies.

#### Text, pp43-44
![[ptolemy-model.png]]
The technical ingenuity that Ptolemy's displays in the Almagest is illustrated by his model of the motion in longitude (that is, around the Sun's path or 'ecliptic') of one of the planets Mars, Jupiter or Saturn. The Earth is at 0, and M is the centre of the large (deferent) circle. C is a point on the deferent circle, and is itself the centre of the epicycle on which travels the planet P. E is a point (the equant point) on the line OM (extended), such that OM=ME. C moves around on the deferent circle with a variable angular velocity, such that, viewed from the equant point E, it appears to be travelling uniformly. P moves on the epicycle in such a way that CP is always parallel to the line from O to the 'mean Sun' (reflecting the fact that the Earth-based observer is in reality in motion around the Sun). The ratio of the radii of the circles, the 'eccentrity' OM, and the two angular velocities, are then chosen to fit the motion of the particular planet.

---
debate in the universities of the medieval West. It would be difficult enough for university students of Arts to reconcile eccentres and epicycles with what they were taught in their natural philosophy about the uniform motions of the Aristotelian concentric spheres; to reconcile the equant was quite impossible. 

For this very reason, Copernicus in the sixteenth century would see it as a matter for self-congratulation, that his models needed no equants. 

In the Almagest, Ptolemy provided geometric models that would, with fair accuracy, predict the motions of every one of the seven wanderers. He showed how the all-important parameters in his models could be derived from observations, though his general strategy was to work in the opposite direction: to present the models and then to 'test' them by comparing deductions from them against observations. With the help of the Almagest, mathematical astronomers (and astrologers) would be able to calculate tables of the positions of a planet in longitude and latitude for the indefinite future. 

There were of course problems. He had found that the model for the Moon as adapted from Hipparchus represented well enough positions of the planet when Earth, Sun and Moon were in a straight line -unsurprisingly, in view of the use Hipparchus had made of Babylonian eclipse
`p44`
records in deriving his model but was unsatisfactory elsewhere. To remedy the defect, and so account for the Moon's irregularity that later became known as 'evection', he introduced a 'crank' mechanism that varied the distance from Earth of the Moon's epicycle. When Earth, Sun and Moon were aligned, the crank was fully extended and its presence made no difference; but elsewhere the crank pulled in the epicycle towards the Earth, most of all when the angle Sun-Earth-Moon was a right angle. The resulting model was satisfactory as far as computing lunar positions was concerned, but it implied that the height of the Moon above the Earth varied between 33 and 64 Earth radii. This ought to have resulted in its apparent diameter varying by a factor of nearly two; yet such variations were not in fact observed in the real Moon. How much this bothered Ptolemy's readers depended on whether they were looking for something more than accurate tables of position. 

Another problem stemmed from a curious fact of observation. Two of the lesser planets -Mercury and Venus are never to be seen far from the Sun: they rise and set with the Sun, unlike Mars, Jupiter and Saturn which may be seen in the sky at any time of night. Ptolemy replicated this in his models for Venus and Mercury by aligning the centres of their epicycles with the 'mean Sun', sO that all three had the same period of one year. Some of his readers, however, were unhappy with such an ad hoc device. 

But these were details. Ptolemy's Almagest achieved what it set out to do: to provide a set of geometrical models for calculating accurate tables of the future positions in the sky of each of the seven planets. It marked the culmination of centuries of effort.

Ptolemy made no attempt in the Almagest to present an integrated 'Ptolemaic System' of the heavens, but he did permit himself a few sentences on the order of the planets, in terms of their respective heights above the central Earth. It seemed plausible to make the fixed stars the outermost (as indeed Eudoxus and Aristotle had assumed half millennium before), and to place nearest to these stars those planets whose motions most closely imitated the motion of the stars. On this basis Saturn -whose motion differed from that of the stars by only one circuit every thirty years -was the highest of the planets, with Jupiter (one in twelve years) and Mars (one in two years) next. At the other extreme, the Moon (one each month) was to be placed closest to the Earth.